/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.multimedia;

import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import java.util.concurrent.locks.ReentrantLock;

public class QtCamera
implements Camera.ShutterCallback,
Camera.PictureCallback,
Camera.AutoFocusCallback,
Camera.PreviewCallback {
    private int m_cameraId = -1;
    private Camera m_camera = null;
    private byte[] m_cameraPreviewFirstBuffer = null;
    private byte[] m_cameraPreviewSecondBuffer = null;
    private int m_actualPreviewBuffer = 0;
    private final ReentrantLock m_buffersLock = new ReentrantLock();
    private boolean m_isReleased = false;
    private boolean m_fetchEachFrame = false;
    private static final String TAG = "Qt Camera";

    private QtCamera(int n, Camera camera) {
        this.m_cameraId = n;
        this.m_camera = camera;
    }

    public static QtCamera open(int n) {
        try {
            Camera camera = Camera.open((int)n);
            return new QtCamera(n, camera);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
            return null;
        }
    }

    public Camera.Parameters getParameters() {
        return this.m_camera.getParameters();
    }

    public void lock() {
        try {
            this.m_camera.lock();
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
        }
    }

    public void unlock() {
        try {
            this.m_camera.unlock();
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
        }
    }

    public void release() {
        this.m_isReleased = true;
        this.m_camera.release();
    }

    public void reconnect() {
        try {
            this.m_camera.reconnect();
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
        }
    }

    public void setDisplayOrientation(int n) {
        this.m_camera.setDisplayOrientation(n);
    }

    public void setParameters(Camera.Parameters parameters) {
        try {
            this.m_camera.setParameters(parameters);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
        }
    }

    public void setPreviewTexture(SurfaceTexture surfaceTexture) {
        try {
            this.m_camera.setPreviewTexture(surfaceTexture);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
        }
    }

    public void fetchEachFrame(boolean bl) {
        this.m_fetchEachFrame = bl;
    }

    public void startPreview() {
        Camera.Size size = this.m_camera.getParameters().getPreviewSize();
        double d = (double)ImageFormat.getBitsPerPixel((int)this.m_camera.getParameters().getPreviewFormat()) / 8.0;
        int n = (int)Math.ceil(d * (double)size.width * (double)size.height);
        this.m_camera.setPreviewCallback(null);
        this.m_buffersLock.lock();
        if (this.m_cameraPreviewFirstBuffer == null || this.m_cameraPreviewFirstBuffer.length < n) {
            this.m_cameraPreviewFirstBuffer = new byte[n];
        }
        if (this.m_cameraPreviewSecondBuffer == null || this.m_cameraPreviewSecondBuffer.length < n) {
            this.m_cameraPreviewSecondBuffer = new byte[n];
        }
        this.addCallbackBuffer();
        this.m_buffersLock.unlock();
        this.m_camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        this.m_camera.startPreview();
    }

    public void stopPreview() {
        this.m_camera.stopPreview();
    }

    public void autoFocus() {
        this.m_camera.autoFocus((Camera.AutoFocusCallback)this);
    }

    public void cancelAutoFocus() {
        this.m_camera.cancelAutoFocus();
    }

    public void takePicture() {
        try {
            this.m_camera.takePicture((Camera.ShutterCallback)this, null, (Camera.PictureCallback)this);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.getMessage());
        }
    }

    public byte[] lockAndFetchPreviewBuffer() {
        byte[] byArray = null;
        this.m_buffersLock.lock();
        if (this.m_actualPreviewBuffer == 1) {
            byArray = this.m_cameraPreviewFirstBuffer;
        } else if (this.m_actualPreviewBuffer == 2) {
            byArray = this.m_cameraPreviewSecondBuffer;
        }
        this.m_actualPreviewBuffer = 0;
        return byArray;
    }

    public void unlockPreviewBuffer() {
        if (this.m_buffersLock.isHeldByCurrentThread()) {
            this.m_buffersLock.unlock();
        }
    }

    private void addCallbackBuffer() {
        if (this.m_isReleased) {
            return;
        }
        this.m_camera.addCallbackBuffer(this.m_actualPreviewBuffer == 1 ? this.m_cameraPreviewSecondBuffer : this.m_cameraPreviewFirstBuffer);
    }

    public void onShutter() {
        QtCamera.notifyPictureExposed(this.m_cameraId);
    }

    public void onPictureTaken(byte[] byArray, Camera camera) {
        QtCamera.notifyPictureCaptured(this.m_cameraId, byArray);
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        this.m_buffersLock.lock();
        if (byArray != null && this.m_fetchEachFrame) {
            QtCamera.notifyFrameFetched(this.m_cameraId, byArray);
        }
        this.m_actualPreviewBuffer = byArray == this.m_cameraPreviewFirstBuffer ? 1 : (byArray == this.m_cameraPreviewSecondBuffer ? 2 : 0);
        this.addCallbackBuffer();
        this.m_buffersLock.unlock();
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        QtCamera.notifyAutoFocusComplete(this.m_cameraId, bl);
    }

    private static native void notifyAutoFocusComplete(int var0, boolean var1);

    private static native void notifyPictureExposed(int var0);

    private static native void notifyPictureCaptured(int var0, byte[] var1);

    private static native void notifyFrameFetched(int var0, byte[] var1);
}

