/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ApplyProfileChangesDialog;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressConstants2;
import org.osgi.framework.BundleContext;

public class ProvisioningOperationRunner {
    boolean suppressRestart = false;
    ProvisioningUI ui;
    public int eventBatchCount = 0;

    public ProvisioningOperationRunner(ProvisioningUI ui) {
        this.ui = ui;
    }

    public void schedule(ProvisioningJob job, int errorStyle) {
        boolean noPrompt;
        boolean bl = noPrompt = (errorStyle & 6) == 0;
        if (noPrompt) {
            job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
            job.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        }
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ProvUIImages.getImageDescriptor("obj/profile_obj.gif"));
        job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        this.manageJob((Job)job, job.getRestartPolicy());
        job.schedule();
    }

    void requestRestart(final int restartPolicy) {
        if (this.suppressRestart) {
            return;
        }
        if (restartPolicy == 1) {
            PlatformUI.getWorkbench().restart();
            return;
        }
        if (restartPolicy == 2) {
            this.applyProfileChanges();
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                int retCode = ApplyProfileChangesDialog.promptForRestart(ProvUI.getDefaultParentShell(), restartPolicy == 3);
                if (retCode == 1) {
                    ProvisioningOperationRunner.this.applyProfileChanges();
                } else if (retCode == 2) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
    }

    void applyProfileChanges() {
        Configurator configurator = (Configurator)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)Configurator.class.getName());
        try {
            configurator.applyConfiguration();
        }
        catch (IOException e) {
            ProvUI.handleException(e, ProvUIMessages.ProvUI_ErrorDuringApplyConfig, 5);
        }
        catch (IllegalStateException e) {
            Status illegalApplyStatus = new Status(2, "org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ProvisioningOperationRunner_CannotApplyChanges, (Throwable)e);
            ProvUI.reportStatus((IStatus)illegalApplyStatus, 5);
        }
    }

    public void manageJob(Job job, final int jobRestartPolicy) {
        this.ui.getSession().rememberJob(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                int severity = event.getResult().getSeverity();
                if (severity != 8 && severity != 4) {
                    if (jobRestartPolicy == 1) {
                        return;
                    }
                    int globalRestartPolicy = ProvisioningOperationRunner.this.ui.getPolicy().getRestartPolicy();
                    if (globalRestartPolicy == 4) {
                        if (jobRestartPolicy == 2) {
                            ProvisioningOperationRunner.this.requestRestart(4);
                        } else {
                            ProvisioningOperationRunner.this.requestRestart(3);
                        }
                    } else {
                        ProvisioningOperationRunner.this.requestRestart(globalRestartPolicy);
                    }
                }
            }
        });
    }

    public void suppressRestart(boolean suppress) {
        this.suppressRestart = suppress;
    }
}

