/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2006;

import finanze.IDTE.generale2006.Dichiarazione;
import finanze.IDTE.generale2006.Ricevuta;
import finanze.IDTE.generale2006.Util;
import finanze.IDTE.resources.ConfigCampo;
import finanze.IDTE.resources.Configurazioni;
import finanze.IDTE.resources.RecordParser;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class TracciatoRicevuta {
    private static TracciatoRicevuta self = null;
    private Configurazioni recordPConfig;
    private Configurazioni recordRConfig;
    public static final String A_CAPO = "\r\n";

    private TracciatoRicevuta() {
    }

    private String creaRecord(String[] fieldValues, RecordParser recB, char recType) {
        StringBuffer record = new StringBuffer();
        Configurazioni confRec = recType == 'P' ? this.recordPConfig : this.recordRConfig;
        int i = 0;
        while (i < fieldValues.length) {
            ConfigCampo currCampo = confRec.getConfigAt(i);
            String value = fieldValues[i].trim();
            if (value.startsWith("B(")) {
                value = recB.prendiValore(Integer.parseInt(value.substring(2, value.length() - 1))).trim();
            } else if (value.startsWith("S(") && (value = recB.prendiValore(Integer.parseInt(value.substring(2, value.length() - 1))).trim()).equals("0")) {
                value = "";
            }
            value = currCampo.formato == 1 || currCampo.formato == 8 ? Util.formStr(currCampo.lunghezza, value, 'R') : Util.formNum(currCampo.lunghezza, value);
            record.append(value);
            ++i;
        }
        return record.toString();
    }

    public static TracciatoRicevuta getInstance() {
        if (self == null) {
            self = new TracciatoRicevuta();
        }
        return self;
    }

    public void riempiConfigurazioni(String tipoMod) throws IOException {
        this.recordPConfig = new Configurazioni(new Vector());
        this.recordRConfig = new Configurazioni(new Vector());
        this.recordPConfig.load(String.valueOf(tipoMod) + "_config_recp" + ".res");
        this.recordRConfig.load(String.valueOf(tipoMod) + "_config_recr" + ".res");
    }

    public void scriviTracciato(RecordParser recB, Dichiarazione dic, Ricevuta ricModello, OutputStream stream) {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream)));
        String[] recValues = ricModello.preparaValoriRecord(recB, dic, this.recordPConfig, 'P');
        out.write(this.creaRecord(recValues, recB, 'P'));
        recValues = ricModello.preparaValoriRecord(recB, dic, this.recordRConfig, 'R');
        out.write(this.creaRecord(recValues, recB, 'R'));
        out.flush();
        out.close();
    }

    public void scriviTracciato(RecordParser recB, Dichiarazione dic, Ricevuta ricModello, String fileName) throws FileNotFoundException {
        this.scriviTracciato(recB, dic, ricModello, new FileOutputStream(fileName));
    }
}

