/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.cms.CounterSignatureListener;
import demo.keystore.CMSKeyStore;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SignedData;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.CounterSignature;
import iaik.cms.attributes.SigningTime;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;

public class CounterSignatureDemo {
    X509Certificate[] certificates;
    PrivateKey user2_sign_pk;
    X509Certificate user2_sign;
    PrivateKey user1_sign_pk;
    X509Certificate user1_sign;
    byte[] message;

    public void start() {
        try {
            byte[] byArray = null;
            System.out.println("\nImplicit SignedDataStream demo [create]:\n");
            byte[] byArray2 = this.createSignedDataStream(this.message, 1);
            System.out.println("\nImplicit SignedDataStream demo [counter sign]:\n");
            byArray2 = this.getSignedDataStream(byArray2, null, true);
            System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
            byArray = this.getSignedDataStream(byArray2, null, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            System.out.println("\nExplicit SignedDataStream demo [create]:\n");
            byArray2 = this.createSignedDataStream(this.message, 2);
            System.out.println("\nExplicit SignedDataStream demo [counter sign]:\n");
            byArray2 = this.getSignedDataStream(byArray2, this.message, true);
            System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
            byArray = this.getSignedDataStream(byArray2, this.message, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            System.out.println("\nImplicit SignedData demo [create]:\n");
            byArray2 = this.createSignedData(this.message, 1);
            System.out.println("\nImplicit SignedData demo [counter sign]:\n");
            byArray2 = this.getSignedData(byArray2, null, true);
            System.out.println("\nImplicit SignedData demo [parse]:\n");
            byArray = this.getSignedData(byArray2, null, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            System.out.println("\nExplicit SignedData demo [create]:\n");
            byArray2 = this.createSignedData(this.message, 2);
            System.out.println("\nExplicit SignedData demo [counter sign]:\n");
            byArray2 = this.getSignedData(byArray2, this.message, true);
            System.out.println("\nExplicit SignedData demo [parse]:\n");
            byArray = this.getSignedData(byArray2, this.message, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            DemoUtil.initDemos();
            new CounterSignatureDemo().start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2, boolean bl) throws Exception {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignedDataStream signedDataStream = null;
        if (byArray2 == null) {
            signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        } else {
            object = new AlgorithmID[]{AlgorithmID.sha1};
            signedDataStream = new SignedDataStream((InputStream)new ByteArrayInputStream(byArray2), (AlgorithmID[])object);
        }
        if (bl) {
            Object object2;
            Closeable closeable;
            object = new CounterSignatureListener((CertificateIdentifier)new IssuerAndSerialNumber(this.user2_sign), AlgorithmID.md5, this.user2_sign_pk);
            ((CounterSignatureListener)((Object)object)).setCertOfSignerToBeCounterSigned(this.user1_sign);
            if (byArray2 == null) {
                object.setOutputStream((OutputStream)byteArrayOutputStream);
                signedDataStream.setSDSEncodeListener((SDSEncodeListener)object);
            } else {
                signedDataStream.setSDSEncodeListener((SDSEncodeListener)object);
                closeable = signedDataStream.getInputStream();
                object2 = new StreamCopier((InputStream)closeable, (OutputStream)byteArrayOutputStream);
                object2.copyStream();
                signedDataStream.decode((InputStream)byteArrayInputStream);
            }
            signedDataStream.setBlockSize(2048);
            closeable = new ByteArrayOutputStream();
            signedDataStream.writeTo((OutputStream)closeable);
            object2 = byteArrayOutputStream.toByteArray();
            System.out.println("Content: " + new String((byte[])object2));
            return ((ByteArrayOutputStream)closeable).toByteArray();
        }
        object = signedDataStream.getInputStream();
        byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)object, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            signedDataStream.decode((InputStream)byteArrayInputStream);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            block18: {
                try {
                    Attribute attribute;
                    CMSContentType cMSContentType;
                    X509Certificate x509Certificate = signedDataStream.verify(n);
                    System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                    SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                    if (signingTime != null) {
                        System.out.println("This message has been signed at " + signingTime.get());
                    }
                    if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                        System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                    }
                    if ((attribute = signerInfoArray[n].getUnsignedAttribute(ObjectID.countersignature)) == null) break block18;
                    AttributeValue[] attributeValueArray = attribute.getAttributeValues();
                    System.out.println("This SignerInfo is counter signed from: ");
                    int n2 = 0;
                    while (n2 < attributeValueArray.length) {
                        CounterSignature counterSignature = (CounterSignature)attributeValueArray[n2];
                        try {
                            if (counterSignature.verify(this.user2_sign.getPublicKey(), signerInfoArray[n])) {
                                System.out.println("Signature OK from counter signer: " + counterSignature.getSignerIdentifier());
                            } else {
                                System.out.println("Signature ERROR from counter signer: " + counterSignature.getSignerIdentifier());
                            }
                        }
                        catch (SignatureException signatureException) {
                            System.out.println("Signature ERROR from counter signer: " + counterSignature.getSignerIdentifier());
                            throw new CMSException(signatureException.toString());
                        }
                        signingTime = (SigningTime)counterSignature.getSignedAttributeValue(ObjectID.signingTime);
                        if (signingTime != null) {
                            System.out.println("Counter signature has been created " + signingTime.get());
                        }
                        ++n2;
                    }
                }
                catch (SignatureException signatureException) {
                    System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                    throw new CMSException(signatureException.toString());
                }
                catch (CodingException codingException) {
                    throw new CMSException("Attribute decoding error: " + codingException.toString());
                }
            }
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignedData(byte[] byArray, byte[] byArray2, boolean bl) throws Exception {
        Object object;
        Attribute[] attributeArray;
        CMSContentType cMSContentType;
        SigningTime signingTime;
        X509Certificate x509Certificate;
        AlgorithmID[] algorithmIDArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedData signedData = null;
        if (byArray2 == null) {
            signedData = new SignedData((InputStream)byteArrayInputStream);
        } else {
            algorithmIDArray = new AlgorithmID[]{AlgorithmID.sha1};
            signedData = new SignedData(byArray2, algorithmIDArray);
            signedData.decode((InputStream)byteArrayInputStream);
        }
        System.out.println("SignedData contains the following signer information:");
        algorithmIDArray = signedData.getSignerInfos();
        int n = 0;
        while (n < algorithmIDArray.length) {
            block15: {
                try {
                    x509Certificate = signedData.verify(n);
                    System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                    signingTime = (SigningTime)algorithmIDArray[n].getSignedAttributeValue(ObjectID.signingTime);
                    if (signingTime != null) {
                        System.out.println("This message has been signed at " + signingTime.get());
                    }
                    if ((cMSContentType = (CMSContentType)algorithmIDArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                        System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                    }
                    if ((attributeArray = algorithmIDArray[n].getUnsignedAttribute(ObjectID.countersignature)) == null) break block15;
                    object = attributeArray.getAttributeValues();
                    System.out.println("This SignerInfo is counter signed from: ");
                    int n2 = 0;
                    while (n2 < ((AttributeValue[])object).length) {
                        CounterSignature counterSignature = (CounterSignature)object[n2];
                        try {
                            if (counterSignature.verify(this.user2_sign.getPublicKey(), (SignerInfo)algorithmIDArray[n])) {
                                System.out.println("Signature OK from counter signer: " + counterSignature.getSignerIdentifier());
                            } else {
                                System.out.println("Signature ERROR from counter signer: " + counterSignature.getSignerIdentifier());
                            }
                        }
                        catch (SignatureException signatureException) {
                            System.out.println("Signature ERROR from counter signer: " + counterSignature.getSignerIdentifier());
                            throw new CMSException(signatureException.toString());
                        }
                        signingTime = (SigningTime)counterSignature.getSignedAttributeValue(ObjectID.signingTime);
                        if (signingTime != null) {
                            System.out.println("Counter signature has been created " + signingTime.get());
                        }
                        ++n2;
                    }
                }
                catch (SignatureException signatureException) {
                    System.out.println("Signature ERROR from signer: " + signedData.getCertificate(algorithmIDArray[n].getSignerIdentifier()).getSubjectDN());
                    throw new CMSException(signatureException.toString());
                }
                catch (CodingException codingException) {
                    throw new CMSException("Attribute decoding error: " + codingException.toString());
                }
            }
            ++n;
        }
        if (bl) {
            x509Certificate = new CounterSignature((CertificateIdentifier)new IssuerAndSerialNumber(this.user2_sign), AlgorithmID.md5, this.user2_sign_pk);
            signingTime = new SigningTime();
            cMSContentType = new CMSContentType[]{new Attribute((AttributeValue)signingTime)};
            x509Certificate.setSignedAttributes((Attribute[])cMSContentType);
            x509Certificate.counterSign((SignerInfo)algorithmIDArray[0]);
            attributeArray = new Attribute[]{new Attribute((AttributeValue)x509Certificate)};
            algorithmIDArray[0].addUnsignedAttributes(attributeArray);
            object = new ByteArrayOutputStream();
            signedData.writeTo((OutputStream)object);
            System.out.println("Content: " + new String(signedData.getContent()));
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        return signedData.getContent();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws Exception {
        Closeable closeable;
        System.out.println("Create a new message signed by user 1:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1_sign);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.user1_sign_pk);
        Attribute[] attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(ObjectID.cms_data)), new Attribute((AttributeValue)new SigningTime())};
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        signedDataStream.setBlockSize(2048);
        if (n == 2) {
            int n2;
            closeable = signedDataStream.getInputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = ((InputStream)closeable).read(byArray2)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        signedDataStream.writeTo((OutputStream)closeable);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public byte[] createSignedData(byte[] byArray, int n) throws Exception {
        System.out.println("Create a new message signed by user 1:");
        SignedData signedData = new SignedData(byArray, n);
        signedData.setCertificates((Certificate[])this.certificates);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1_sign);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.sha1, this.user1_sign_pk);
        Attribute[] attributeArray = new Attribute[]{new Attribute((AttributeValue)new CMSContentType(ObjectID.cms_data)), new Attribute((AttributeValue)new SigningTime())};
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        signedData.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public CounterSignatureDemo() {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                      CounterSignatureDemo demo                                 *");
        System.out.println("*       (shows the usage of the CounterSignature attribute implementation)       *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.message = "This is a test of the CMS implementation!".getBytes();
        this.certificates = CMSKeyStore.getCertificateChain(0, 1);
        this.user1_sign = this.certificates[0];
        this.user1_sign_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.user2_sign = CMSKeyStore.getCertificateChain(0, 2)[0];
        this.user2_sign_pk = CMSKeyStore.getPrivateKey(0, 2);
    }
}

