/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.IA5String;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.OtherName;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class GeneralName {
    private int b = -1;
    private static final int e = 1;
    private static final int d = 0;
    private Object c;
    private int a = -1;
    public static final int registeredID = 8;
    public static final int iPAddress = 7;
    public static final int uniformResourceIdentifier = 6;
    public static final int ediPartyName = 5;
    public static final int directoryName = 4;
    public static final int x400Address = 3;
    public static final int dNSName = 2;
    public static final int rfc822Name = 1;
    public static final int otherName = 0;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a) {
            case 0: {
                stringBuffer.append("otherName: ");
                break;
            }
            case 1: {
                stringBuffer.append("rfc822Name: ");
                break;
            }
            case 2: {
                stringBuffer.append("dNSName: ");
                break;
            }
            case 3: {
                stringBuffer.append("x400Address: ");
                break;
            }
            case 4: {
                stringBuffer.append("directoryName: ");
                break;
            }
            case 5: {
                stringBuffer.append("ediPartyName: ");
                break;
            }
            case 6: {
                stringBuffer.append("uniformResourceIdentifier: ");
                break;
            }
            case 7: {
                stringBuffer.append("iPAddress: ");
                break;
            }
            case 8: {
                stringBuffer.append("registeredID: ");
                break;
            }
            default: {
                stringBuffer.append("undefined");
            }
        }
        if (this.a >= 0) {
            if (this.a == 7) {
                String string = GeneralName.a((byte[])this.c);
                if (string != null) {
                    stringBuffer.append(string);
                }
            } else {
                stringBuffer.append(this.c.toString());
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        ASN1Object aSN1Object = null;
        boolean bl = true;
        switch (this.a) {
            case 0: {
                if (this.c instanceof OtherName) {
                    aSN1Object = ((OtherName)this.c).toASN1Object();
                    break;
                }
                aSN1Object = (ASN1Object)this.c;
                break;
            }
            case 3: 
            case 5: {
                aSN1Object = (ASN1Object)this.c;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                aSN1Object = new IA5String((String)this.c);
                break;
            }
            case 7: {
                aSN1Object = new OCTET_STRING((byte[])this.c);
                break;
            }
            case 4: {
                aSN1Object = ((Name)this.c).toASN1Object();
                bl = false;
                break;
            }
            case 8: {
                aSN1Object = (ObjectID)this.c;
                break;
            }
            default: {
                throw new CodingException("GeneralName: type " + this.a + " not implemented yet!");
            }
        }
        if (this.b > -1) {
            bl = this.b == 0;
        }
        return new CON_SPEC(this.a, aSN1Object, bl);
    }

    private static String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            String string;
            int n2 = byArray.length;
            if (n2 < 16) {
                StringBuffer stringBuffer = new StringBuffer(n2 == 4 ? 15 : 32);
                stringBuffer.append(Integer.toString(byArray[0] & 0xFF));
                int n3 = 1;
                while (n3 < n2) {
                    if (n3 == 4) {
                        stringBuffer.append("/");
                    } else {
                        stringBuffer.append(".");
                    }
                    stringBuffer.append(Integer.toString(byArray[n3++] & 0xFF));
                }
                string = stringBuffer.toString();
            } else {
                StringBuffer stringBuffer = new StringBuffer(n2 == 16 ? 39 : 81);
                stringBuffer.append(Integer.toHexString(byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF));
                int n4 = 2;
                while (n4 < n2) {
                    if (n4 == 16) {
                        stringBuffer.append("/");
                    } else {
                        stringBuffer.append(":");
                    }
                    stringBuffer.append(Integer.toHexString(byArray[n4] << 8 & 0xFF00 | byArray[++n4] & 0xFF));
                    ++n4;
                }
                string = stringBuffer.toString().toUpperCase();
            }
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public int hashCode() {
        int n2 = this.a;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                n2 += Util.calculateHashCode(DerCoder.encode((ASN1Object)this.c));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 += this.c.hashCode();
                break;
            }
            case 7: {
                n2 += Util.calculateHashCode((byte[])this.c);
                break;
            }
            default: {
                n2 += "undefined".hashCode();
            }
        }
        return n2;
    }

    public int getType() {
        return this.a;
    }

    public Object getName() {
        if (this.a == 7) {
            return GeneralName.a((byte[])this.c);
        }
        return this.c;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralName)) {
            return false;
        }
        GeneralName generalName = (GeneralName)object;
        if (this.a != generalName.a) {
            return false;
        }
        boolean bl = false;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                bl = CryptoUtils.equalsBlock(DerCoder.encode((ASN1Object)this.c), DerCoder.encode((ASN1Object)generalName.c));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                bl = this.c.equals(generalName.c);
                break;
            }
            case 7: {
                bl = CryptoUtils.equalsBlock((byte[])this.c, (byte[])generalName.c);
                break;
            }
            default: {
                throw new InternalErrorException("GeneralName: type " + this.a + " not implemented yet!");
            }
        }
        return bl;
    }

    private static byte[] a(String string) throws CodingException {
        byte[] byArray = null;
        if (string == null) {
            throw new NullPointerException("ipAddress must not be null!");
        }
        string.length();
        if (string.indexOf(".") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "./");
            int n2 = stringTokenizer.countTokens();
            if (n2 != 4 && n2 != 8) {
                throw new CodingException("Not supported ipv4 address format (invalid length)!");
            }
            byArray = new byte[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n4 = Integer.parseInt(string2);
                if (n4 < 0 || n4 > 255) {
                    throw new CodingException("Not supported ipv4 address format (out of range)!");
                }
                byArray[n3++] = (byte)n4;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":/");
            int n5 = stringTokenizer.countTokens();
            if (n5 != 8 && n5 != 16) {
                throw new CodingException("Not supported ipv6 address format (invalid length)!");
            }
            byArray = new byte[n5 * 2];
            int n6 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n7 = Integer.parseInt(string3, 16);
                if (n7 < 0 || n7 > 65535) {
                    throw new CodingException("Not supported ipv64 address format (out of range)!");
                }
                byArray[n6++] = (byte)(n7 >> 8);
                byArray[n6++] = (byte)n7;
            }
        }
        return byArray;
    }

    public GeneralName(ASN1Object aSN1Object) throws CodingException {
        ASN1Object aSN1Object2 = null;
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("No GeneralName structure!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.a = aSN1Object.getAsnType().getTag();
        this.b = 0;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                if (cON_SPEC.countComponents() > 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                } else {
                    this.b = 1;
                }
                this.c = cON_SPEC.getValue();
                if (this.a != 0) break;
                if (!(this.c instanceof ASN1Object)) {
                    throw new CodingException("OtherName must be ASN1Object!");
                }
                ASN1Object aSN1Object3 = (ASN1Object)this.c;
                int n2 = aSN1Object3.countComponents();
                if (n2 != 2) {
                    throw new CodingException("Invalid number (" + n2 + ") of components in OtherName. Must be 2!");
                }
                ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(0);
                if (!aSN1Object4.isA(ASN.ObjectID)) {
                    throw new CodingException("Missing type component of OtherName!");
                }
                try {
                    OtherName otherName = OtherName.create((ObjectID)aSN1Object4);
                    otherName.decode(aSN1Object3);
                    this.c = otherName;
                    return;
                }
                catch (InstantiationException instantiationException) {
                    return;
                }
            }
            case 1: 
            case 2: 
            case 6: {
                cON_SPEC.forceImplicitlyTagged(ASN.IA5String);
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                this.c = (String)aSN1Object2.getValue();
                return;
            }
            case 7: {
                cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof OCTET_STRING)) {
                    throw new CodingException("Cannot parse GeneralName. Expected OCTET_STRING!");
                }
                byte[] byArray = (byte[])aSN1Object2.getValue();
                int n3 = byArray.length;
                if (n3 != 4 && n3 != 8 && n3 != 16 && n3 != 32) {
                    throw new IllegalArgumentException("Invalid ipAddress format (invalid length " + n3 + ")!");
                }
                this.c = byArray;
                return;
            }
            case 4: {
                Object object = cON_SPEC.getValue();
                if (object instanceof ASN1Object && ((ASN1Object)object).getAsnType().equals(ASN.SEQUENCE)) {
                    this.b = 1;
                } else {
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                }
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof SEQUENCE)) {
                    throw new CodingException("Cannot parse GeneralName of type directoryName!  Name has to be a SEQUENCE!");
                }
                this.c = new Name(aSN1Object2);
                return;
            }
            case 8: {
                Object object = cON_SPEC.getValue();
                if (object instanceof ASN1Object && ((ASN1Object)object).getAsnType().equals(ASN.ObjectID)) {
                    this.b = 1;
                } else {
                    cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
                }
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof ObjectID)) {
                    throw new CodingException("Cannot parse GeneralName of type registeredID. Expected an ObjectID instance!");
                }
                this.c = (ObjectID)aSN1Object2;
                return;
            }
            default: {
                throw new CodingException("Cannot parse GeneralName! Illegal type specification! Type has to be in the range of 0...8!");
            }
        }
    }

    public GeneralName(int n2, Object object) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                if (object instanceof ASN1Object || object instanceof OtherName) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Expecting ASN1Object for type otherName!");
            }
            case 3: 
            case 5: {
                if (object instanceof ASN1Object) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Wrong generalName argument! Expecting ASN1Object!");
            }
            case 1: 
            case 2: 
            case 6: {
                if (object instanceof String) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Wrong generalName argument! Expected a String instance!");
            }
            case 7: {
                if (object instanceof InetAddress) {
                    this.c = ((InetAddress)object).getAddress();
                    break;
                }
                if (object instanceof byte[]) {
                    int n3 = ((byte[])object).length;
                    if (n3 != 4 && n3 != 8 && n3 != 16 && n3 != 32) {
                        throw new IllegalArgumentException("Invalid ipAddress format (invalid length " + n3 + ")!");
                    }
                    this.c = object;
                    break;
                }
                if (object instanceof String) {
                    try {
                        this.c = GeneralName.a((String)object);
                        break;
                    }
                    catch (CodingException codingException) {
                        try {
                            this.c = InetAddress.getByName((String)object).getAddress();
                            break;
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw new IllegalArgumentException("Cannot create GeneralName from given ipAddress: " + codingException.getMessage());
                        }
                    }
                }
                throw new IllegalArgumentException("Cannot create GeneralName! Wrong ipAddress format! Expected InetAddress object or byte array!");
            }
            case 4: {
                if (object instanceof Name) break;
                throw new IllegalArgumentException("Cannot create GeneralName type directoryName! Wrong generalName argument! Expected a Name instance!");
            }
            case 8: {
                if (object instanceof ObjectID) break;
                throw new IllegalArgumentException("Cannot create GeneralName type registeredID! Wrong generalName argument! Expected an ObjectID instance!");
            }
            default: {
                throw new IllegalArgumentException("Cannot create GeneralName! Illegal type specification: " + n2 + "!. " + "Type has to be in the range of 0...8!");
            }
        }
        if (n2 != 7) {
            this.c = object;
        }
        this.a = n2;
    }
}

