/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BiometricData
implements ASN1Type {
    String b;
    byte[] d;
    AlgorithmID c;
    ASN1Object a;
    public static final int handwritten_signature = 1;
    public static final int picture = 0;
    private static boolean e;

    public boolean verifyBiometricDataHash(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = this.a(this.c, inputStream);
            if (CryptoUtils.equalsBlock(byArray, this.d)) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Cannot verify hash: " + noSuchAlgorithmException.getMessage());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verifyBiometricDataHash() throws IOException {
        boolean bl;
        if (this.b == null) {
            throw new IOException("Cannot obtain data. No source data uri included!");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.a(this.b);
            bl = this.verifyBiometricDataHash(inputStream);
            Object var4_3 = null;
            if (inputStream == null) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return bl;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public String toString() {
        var1_1 = new StringBuffer();
        var1_1.append("typeOfBiometricData: ");
        if (!this.a.isA(ASN.INTEGER)) ** GOTO lbl14
        switch (((BigInteger)this.a.getValue()).intValue()) {
            case 0: {
                var1_1.append("picture");
                break;
            }
            case 1: {
                var1_1.append("handwritten-signature");
                break;
            }
lbl14:
            // 1 sources

            var1_1.append(this.a);
            break;
        }
        var1_1.append("\n");
        var1_1.append("hashAlgorithm: " + this.c.getName() + "\n");
        var1_1.append("biometricDataHash: " + this.getBiometricDataHashAsString() + "\n");
        if (this.b != null) {
            var1_1.append("sourceDataUri: " + this.b + "\n");
        }
        return var1_1.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null) {
            throw new CodingException("Cannot create ASN.1 object. Missing biometricDataOid!");
        }
        if (this.c == null) {
            throw new CodingException("Cannot create ASN.1 object. Missing hash algorithm!");
        }
        if (this.d == null) {
            throw new CodingException("Cannot create ASN.1 object. Missing biometric data hash!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.d));
        if (this.b != null) {
            sEQUENCE.addComponent(new IA5String(this.b));
        }
        return sEQUENCE;
    }

    public void setSourceDataUri(String string) {
        this.b = string;
    }

    public void setBiometricDataHash(AlgorithmID algorithmID, byte[] byArray) {
        this.c = algorithmID;
        this.d = byArray;
    }

    public void setBiometricDataHash(AlgorithmID algorithmID, String string) throws NoSuchAlgorithmException, IOException {
        this.b = string;
        InputStream inputStream = null;
        try {
            inputStream = this.a(string);
            this.setBiometricDataHash(algorithmID, inputStream);
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                if (inputStream == null) break block3;
                inputStream.close();
            }
            throw throwable;
        }
        Object var5_4 = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public void setBiometricDataHash(AlgorithmID algorithmID, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        this.c = algorithmID;
        this.d = this.a(algorithmID, inputStream);
    }

    public ASN1Object getTypeOfBiometricData() {
        return this.a;
    }

    public String getSourceDataUri() {
        return this.b;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.c;
    }

    public String getBiometricDataHashAsString() {
        return Util.toString(this.d);
    }

    public byte[] getBiometricDataHash() {
        return this.d;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2;
        this.a = aSN1Object.getComponentAt(0);
        if (this.a == null) {
            throw new CodingException("Inavlid BiometricData. No biometricData type!");
        }
        if (this.a.isA(ASN.INTEGER) && (n2 = ((BigInteger)this.a.getValue()).intValue()) < 0 && n2 > 1) {
            throw new CodingException("Unknown predefined biometric type: " + n2);
        }
        this.c = new AlgorithmID(aSN1Object.getComponentAt(1));
        this.d = (byte[])aSN1Object.getComponentAt(2).getValue();
        if (this.d == null) {
            throw new CodingException("Cannot initialize this BiometricData. Missing biometric data hash!");
        }
        if (aSN1Object.countComponents() == 4) {
            this.b = (String)aSN1Object.getComponentAt(3).getValue();
        }
    }

    private InputStream a(String string) throws IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.connect();
        int n2 = httpURLConnection.getResponseCode();
        if (e) {
            System.out.println("Response code: " + n2);
        }
        if (n2 / 100 != 2) {
            throw new IOException("Cannot access source data!");
        }
        int n3 = httpURLConnection.getContentLength();
        if (e) {
            System.out.println("Content length: " + n3);
        }
        if (httpURLConnection.getContentLength() != 0) {
            return httpURLConnection.getInputStream();
        }
        throw new IOException("Cannot access source data!");
    }

    private byte[] a(AlgorithmID algorithmID, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        byte[] byArray = new byte[2048];
        while (digestInputStream.read(byArray) > 0) {
        }
        return messageDigest.digest();
    }

    public BiometricData(ObjectID objectID) {
        this.a = objectID;
    }

    public BiometricData(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public BiometricData(int n2) throws IllegalArgumentException {
        if (n2 < 0 && n2 > 1) {
            throw new IllegalArgumentException("Unknown predefined biometric type: " + n2);
        }
        this.a = new INTEGER(n2);
    }

    public BiometricData() {
    }
}

