/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.demo.html.HTMLParser;
import org.eclipse.help.internal.search.ASCIIReader;

public class HTMLDocParser {
    public static final int MAX_OFFSET = 2048;
    static final String ELEMENT_META = "META";
    static final String ELEMENT_BODY = "body";
    static final String ELEMENT_HEAD = "head";
    static final String ATTRIBUTE_HTTP = "http-equiv";
    static final String ATTRIBUTE_HTTP_VALUE = "content-type";
    static final String ATTRIBUTE_CONTENT = "content";
    static final int STATE_ELEMENT_START = 0;
    static final int STATE_ELEMENT_AFTER_LT = 1;
    static final int STATE_ELEMENT_AFTER_LT_SLASH = 2;
    static final int STATE_ELEMENT_META = 3;
    static final int STATE_HTTP_START = 0;
    static final int STATE_HTTP_AFTER_NAME = 1;
    static final int STATE_HTTP_AFTER_EQ = 2;
    static final int STATE_HTTP_DONE = 3;
    static final int STATE_CONTENT_START = 0;
    static final int STATE_CONTENT_AFTER_NAME = 1;
    static final int STATE_CONTENT_AFTER_EQ = 2;
    static final int STATE_CONTENT_DONE = 3;
    private HTMLParser htmlParser;
    private InputStream inputStream = null;

    public void openDocument(URL url) throws IOException {
        this.inputStream = url.openStream();
        String encoding = HTMLDocParser.getCharsetFromHTML(this.inputStream);
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {}
        this.inputStream = url.openStream();
        if (encoding != null) {
            try {
                this.htmlParser = new HTMLParser(new InputStreamReader(this.inputStream, encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.htmlParser = new HTMLParser(new InputStreamReader(this.inputStream));
            }
        } else {
            this.htmlParser = new HTMLParser(new InputStreamReader(this.inputStream));
        }
        this.htmlParser.parse();
    }

    public void closeDocument() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getTitle() throws IOException {
        if (this.htmlParser == null) {
            throw new NullPointerException();
        }
        try {
            return this.htmlParser.getTitle();
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
    }

    public String getSummary(String title) throws IOException {
        try {
            return this.htmlParser.getSummary();
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
    }

    public Reader getContentReader() throws IOException {
        if (this.htmlParser == null) {
            throw new NullPointerException();
        }
        return this.htmlParser.getReader();
    }

    public static String getCharsetFromHTML(InputStream is) {
        ASCIIReader asciiReader = new ASCIIReader(is, 2048);
        StreamTokenizer tokenizer = new StreamTokenizer(asciiReader);
        tokenizer.lowerCaseMode(false);
        tokenizer.ordinaryChar(39);
        tokenizer.ordinaryChar(47);
        String charset = HTMLDocParser.getCharsetFromHTMLTokens(tokenizer);
        if (asciiReader != null) {
            try {
                ((Reader)asciiReader).close();
            }
            catch (IOException iOException) {}
        }
        return charset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCharsetFromHTMLTokens(StreamTokenizer tokenizer) {
        String contentValue = null;
        int stateContent = 0;
        int stateElement = 0;
        int stateHttp = 0;
        try {
            int token = tokenizer.nextToken();
            while (true) {
                if (token == -1) {
                    return null;
                }
                block1 : switch (stateElement) {
                    case 0: {
                        if (token != 60) break;
                        stateElement = 1;
                        break;
                    }
                    case 1: {
                        if (token == -3) {
                            if (ELEMENT_META.equalsIgnoreCase(tokenizer.sval)) {
                                stateElement = 3;
                                stateHttp = 0;
                                stateContent = 0;
                                contentValue = null;
                                break;
                            }
                            if (ELEMENT_BODY.equalsIgnoreCase(tokenizer.sval)) {
                                return null;
                            }
                            stateElement = 0;
                            break;
                        }
                        if (token == 47) {
                            stateElement = 2;
                            break;
                        }
                        stateElement = 0;
                        break;
                    }
                    case 2: {
                        if (token == -3 && ELEMENT_HEAD.equalsIgnoreCase(tokenizer.sval)) {
                            return null;
                        }
                        stateElement = 0;
                        break;
                    }
                    default: {
                        switch (token) {
                            case 62: {
                                stateElement = 0;
                                break block1;
                            }
                            case -3: {
                                if (ATTRIBUTE_HTTP.equalsIgnoreCase(tokenizer.sval)) {
                                    stateHttp = 1;
                                    break block1;
                                }
                                if (ATTRIBUTE_CONTENT.equalsIgnoreCase(tokenizer.sval)) {
                                    stateContent = 1;
                                    break block1;
                                }
                                if (stateHttp == 2 && ATTRIBUTE_HTTP_VALUE.equalsIgnoreCase(tokenizer.sval)) {
                                    stateHttp = 3;
                                    break block1;
                                }
                                if (stateHttp != 3) {
                                    stateHttp = 0;
                                }
                                if (stateContent == 3) break block1;
                                stateContent = 0;
                                break block1;
                            }
                            case 61: {
                                if (stateHttp == 1) {
                                    stateHttp = 2;
                                    break block1;
                                }
                                if (stateContent == 1) {
                                    stateContent = 2;
                                    break block1;
                                }
                                if (stateHttp != 3) {
                                    stateHttp = 0;
                                }
                                if (stateContent == 3) break block1;
                                stateContent = 0;
                                break block1;
                            }
                            case 34: {
                                if (stateHttp == 2) {
                                    if (!ATTRIBUTE_HTTP_VALUE.equalsIgnoreCase(tokenizer.sval)) break block1;
                                    stateHttp = 3;
                                    break block1;
                                }
                                if (stateContent == 2) {
                                    stateContent = 3;
                                    contentValue = tokenizer.sval;
                                    break block1;
                                }
                                stateHttp = 0;
                                stateContent = 0;
                                break block1;
                            }
                            default: {
                                if (stateHttp != 3) {
                                    stateHttp = 0;
                                }
                                if (stateContent == 3) break block1;
                                stateContent = 0;
                            }
                        }
                    }
                }
                if (contentValue != null && stateHttp == 3 && stateContent == 3) {
                    return HTMLDocParser.getCharsetFromHTTP(contentValue);
                }
                token = tokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getCharsetFromHTTP(String contentValue) {
        StringTokenizer t = new StringTokenizer(contentValue, ";");
        while (t.hasMoreTokens()) {
            String charset;
            String parameter = t.nextToken().trim();
            if (!parameter.toLowerCase(Locale.ENGLISH).startsWith("charset=") || (charset = parameter.substring("charset=".length()).trim()).length() <= 0) continue;
            return charset;
        }
        return null;
    }

    public Exception getException() {
        if (this.htmlParser != null) {
            return this.htmlParser.getException();
        }
        return null;
    }
}

