/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.prism.Image;
import com.sun.prism.impl.PrismSettings;
import java.io.IOException;
import java.io.InputStream;

public class PrismImageLoader2
implements ImageLoader {
    private Image[] images;
    private int[] delayTimes;
    private int width;
    private int height;
    private boolean error;
    private Exception exception;

    public PrismImageLoader2(String string, int n, int n2, boolean bl, boolean bl2) {
        this.loadAll(string, n, n2, bl, bl2);
    }

    public PrismImageLoader2(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        this.loadAll(inputStream, n, n2, bl, bl2);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getFrameCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.length;
    }

    @Override
    public PlatformImage getFrame(int n) {
        if (this.images == null) {
            return null;
        }
        return this.images[n];
    }

    @Override
    public PlatformImage[] getFrames() {
        return this.images;
    }

    @Override
    public int getFrameDelay(int n) {
        if (this.images == null) {
            return 0;
        }
        return this.delayTimes[n];
    }

    @Override
    public boolean getError() {
        return this.error;
    }

    public Exception getException() {
        return this.exception;
    }

    private void loadAll(String string, int n, int n2, boolean bl, boolean bl2) {
        PrismLoadListener prismLoadListener = new PrismLoadListener();
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(string, (ImageLoadListener)prismLoadListener, n, n2, bl, bl2);
            this.convertAll(imageFrameArray);
        }
        catch (Exception exception) {
            if (PrismSettings.verbose) {
                exception.getCause().printStackTrace(System.err);
            }
            this.error = true;
            this.exception = exception;
        }
    }

    private void loadAll(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        PrismLoadListener prismLoadListener = new PrismLoadListener();
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(inputStream, (ImageLoadListener)prismLoadListener, n, n2, bl, bl2);
            this.convertAll(imageFrameArray);
        }
        catch (Exception exception) {
            if (PrismSettings.verbose) {
                exception.getCause().printStackTrace(System.err);
            }
            this.error = true;
            this.exception = exception;
        }
    }

    private void convertAll(ImageFrame[] imageFrameArray) {
        int n = imageFrameArray.length;
        this.images = new Image[n];
        this.delayTimes = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2;
            ImageFrame imageFrame = imageFrameArray[i];
            this.images[i] = Image.convertImageFrame(imageFrame);
            ImageMetadata imageMetadata = imageFrame.getMetadata();
            if (imageMetadata != null && (n2 = imageMetadata.delayTime) != null) {
                this.delayTimes[i] = n2;
            }
            if (i != 0) continue;
            this.width = imageFrame.getWidth();
            this.height = imageFrame.getHeight();
        }
    }

    static class AsyncImageLoader
    extends AbstractRemoteResource<PrismImageLoader2> {
        int width;
        int height;
        boolean preserveRatio;
        boolean smooth;

        public AsyncImageLoader(AsyncOperationListener<PrismImageLoader2> asyncOperationListener, String string, int n, int n2, boolean bl, boolean bl2) {
            super(string, asyncOperationListener);
            this.width = n;
            this.height = n2;
            this.preserveRatio = bl;
            this.smooth = bl2;
        }

        @Override
        protected PrismImageLoader2 processStream(InputStream inputStream) throws IOException {
            return new PrismImageLoader2(inputStream, this.width, this.height, this.preserveRatio, this.smooth);
        }
    }

    private class PrismLoadListener
    implements ImageLoadListener {
        private PrismLoadListener() {
        }

        @Override
        public void imageLoadWarning(com.sun.javafx.iio.ImageLoader imageLoader, String string) {
            PrismImageLoader2.this.error = true;
        }

        @Override
        public void imageLoadProgress(com.sun.javafx.iio.ImageLoader imageLoader, float f) {
        }

        @Override
        public void imageLoadMetaData(com.sun.javafx.iio.ImageLoader imageLoader, ImageMetadata imageMetadata) {
        }
    }
}

